/*
 * Decompiled with CFR 0.152.
 */
package panther.program;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import panther.program.AbstractScore;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.result.PrimaryEvidenceIdentification;
import pse.result.PrimaryObservable;
import pse.result.Result;
import pse.util.general.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSEMarvelScore
extends AbstractScore {
    private static final String PRIMARY_OBSERVABLE = "PRIMARY_OBSERVABLE";

    public static void main(String[] stringArray) {
        try {
            System.out.println("PSEMarvelScore - Start");
            if (stringArray.length == 0) {
                System.out.println("Please pass the pse-grade-request XML String as an argument in the command line");
                System.exit(-1);
            }
            Document document = XmlUtils.parseToDocument(stringArray[0]);
            Node node = XmlUtils.getChildNamed(document, "pse-grade-request");
            PSEMarvelScore pSEMarvelScore = new PSEMarvelScore();
            HashMap<String, Object> hashMap = pSEMarvelScore.getObservableMap(node);
            Set<String> set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                System.out.println("Observable-out " + string + " value=" + string2);
            }
            System.out.println("PSEMarvelScore - End");
        }
        catch (Exception exception) {
            System.out.println("Error in PSEMarvelScore" + exception.getMessage());
        }
    }

    public HashMap<String, Object> getObservableMap(Node node) throws Exception {
        Node node2 = XmlUtils.getChildNamed(node, "panther-task");
        Node node3 = XmlUtils.getChildNamed(node2, "observables");
        HashMap<String, String> hashMap = new HashMap();
        hashMap = this.getPrimaryObservablesMap(node);
        HashMap<Object, Object> hashMap2 = new HashMap();
        hashMap2 = this.getCompoundObservablesMap(hashMap, node3);
        hashMap2.put(PRIMARY_OBSERVABLE, hashMap);
        return hashMap2;
    }

    private HashMap<String, String> getPrimaryObservablesMap(Node node) throws Exception {
        Object object;
        Node node2 = XmlUtils.getChildNamed(node, "panther-task");
        Node node3 = XmlUtils.getChildNamed(node2, "observables");
        Node node4 = XmlUtils.getChildNamed(node3, "primaries");
        NodeList nodeList = node4.getChildNodes();
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            String string = XmlUtils.getAttributeValue((Node)object, "panther-ident");
            hashMap.put(string, "false");
        }
        Node node5 = XmlUtils.getChildNamed(node, "scoring-data");
        object = node5.getChildNodes();
        int n2 = object.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node6 = object.item(i);
            if (node6.getNodeType() != 1) continue;
            String string = XmlUtils.getAttributeValue(node6, "id");
            String string2 = XmlUtils.getAttributeValue(node6, "value");
            if (!"true".equals(string2)) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public HashMap<String, Object> getCompoundObservablesMap(HashMap<String, String> hashMap, Node node) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"compounds".equals(node2.getNodeName())) continue;
            hashMap2 = this.getCompoundObservableMap(hashMap, node2);
        }
        return hashMap2;
    }

    public HashMap<String, Object> getCompoundObservableMap(HashMap<String, String> hashMap, Node node) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = XmlUtils.getAttributeValue(node2, "panther-ident");
            String string2 = XmlUtils.getAttributeValue(node2, "maximum-points");
            string2 = string2 == null ? "0" : string2;
            int n2 = new Integer(string2);
            String string3 = XmlUtils.getAttributeValue(node2, "level");
            int n3 = 0;
            NodeList nodeList2 = node2.getChildNodes();
            int n4 = nodeList2.getLength();
            for (int j = 0; j < n4; ++j) {
                String string4;
                Node node3 = nodeList2.item(j);
                if (node3.getNodeType() != 1 || !"observable-ref".equals(node3.getNodeName())) continue;
                String string5 = XmlUtils.getAttributeValue(node3, "panther-ident");
                String string6 = string4 = hashMap.get(string5) == null ? "false" : hashMap.get(string5).toString();
                if ("1".equals(string3)) {
                    n3 = n2;
                    if ("false".equals(string4)) {
                        n3 = 0;
                        break;
                    }
                }
                if ("1".equals(string3)) continue;
                n3 += hashMap2.get(string5) == null ? 0 : new Integer(hashMap2.get(string5).toString());
            }
            hashMap2.put(string, new Integer(n3).toString());
        }
        return hashMap2;
    }

    public void setMarvelCompoundObservableEarnedPoints(Result result, HashMap<String, Object> hashMap) throws Exception {
        CompoundEvidenceIdentification compoundEvidenceIdentification = result.getCompoundEvidenceIdentification();
        List<CompoundObservable> list = compoundEvidenceIdentification.getCompoundObservables();
        for (CompoundObservable compoundObservable : list) {
            String string = compoundObservable.getPantherIdent();
            int n = hashMap.get(string) == null ? 0 : new Integer(hashMap.get(string).toString());
            compoundObservable.setEarnedPoints(n);
        }
    }

    public void setMarvelPrimaryObservable(Result result, HashMap<String, Object> hashMap) throws Exception {
        HashMap hashMap2 = (HashMap)hashMap.get(PRIMARY_OBSERVABLE);
        PrimaryEvidenceIdentification primaryEvidenceIdentification = result.getPrimaryEvidenceIdentification();
        List<PrimaryObservable> list = primaryEvidenceIdentification.getPrimaryObservables();
        for (PrimaryObservable primaryObservable : list) {
            String string = primaryObservable.getPantherIdent();
            boolean bl = hashMap2.get(string) == null ? false : new Boolean(hashMap2.get(string).toString());
            primaryObservable.setCorrect(bl);
        }
    }

    public void setMarvelReportingObservable(Result result, Node node, HashMap<String, Object> hashMap) throws Exception {
        Node node2 = XmlUtils.getChildNamed(node, "observables");
        Node node3 = XmlUtils.getChildNamed(node2, "reporting");
        NodeList nodeList = node3.getChildNodes();
        int n = nodeList.getLength();
        CompoundEvidenceIdentification compoundEvidenceIdentification = result.getCompoundEvidenceIdentification();
        CompoundObservable compoundObservable = null;
        for (int i = 0; i < n; ++i) {
            Node node4;
            String string;
            int n2;
            String string2;
            Node node5 = nodeList.item(i);
            if (node5.getNodeType() != 1 || (string2 = this.getFeedback(node5, n2 = hashMap.get(string = XmlUtils.getAttributeValue(node4 = XmlUtils.getChildNamed(node5, "observable-ref"), "panther-ident")) == null ? 0 : new Integer(hashMap.get(string).toString()))).trim().length() <= 0) continue;
            compoundObservable = new CompoundObservable();
            compoundObservable.setPantherIdent(XmlUtils.getAttributeValue(node5, "panther-ident"));
            compoundObservable.setFeedback(string2);
            compoundEvidenceIdentification.addCompoundObservable(compoundObservable);
        }
        result.setCompoundEvidenceIdentification(compoundEvidenceIdentification);
    }

    private String getFeedback(Node node, int n) throws Exception {
        String string = "";
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Integer n3;
            Integer n4;
            boolean bl;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"feedback-range".equals(node2.getNodeName()) || !(bl = this.isWithinRange(n, n4 = Integer.valueOf(XmlUtils.getAttributeValue(node2, "minimum") == null ? 0 : new Integer(XmlUtils.getAttributeValue(node2, "minimum"))), n3 = Integer.valueOf(XmlUtils.getAttributeValue(node2, "maximum") == null ? 0 : new Integer(XmlUtils.getAttributeValue(node2, "maximum")))))) continue;
            return XmlUtils.getText(node2);
        }
        return string;
    }

    private boolean isWithinRange(int n, Integer n2, Integer n3) {
        return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
    }
}

